<?php

include ('includes/header.php');

// Table name
$table_name = "app_announce";

// Select data
$res = $db->select($table_name, '*', '', '');

// Update data
@$resU = $db->select($table_name, '*', 'id = :id', '', [':id' => $_GET['update']]);

if(isset($_POST['submitU'])){
    unset($_POST['submitU']);
    $updateData = $_POST;
    $updateData['created_at'] = date('Y-m-d H:i:s');
    $db->update($table_name, $updateData, 'id = :id', [':id' => $_GET['update']]);
    echo "<script>window.location.href='". basename($_SERVER["SCRIPT_NAME"])."?status=1'</script>";
}

// Submit new data
if (isset($_POST['submit'])){
    unset($_POST['submit']);
    $_POST['created_at'] = date('Y-m-d H:i:s');
    $db->insert($table_name, $_POST);
    $db->close();
    echo "<script>window.location.href='". basename($_SERVER["SCRIPT_NAME"])."?status=1'</script>";
}

// Delete row
if(isset($_GET['delete'])){
    $db->delete($table_name, 'id = :id', [':id' => $_GET['delete']]);
    echo "<script>window.location.href='". basename($_SERVER["SCRIPT_NAME"])."?status=2'</script>";
}

// Delete modal
?>
<div class="modal fade" id="confirm-delete" tabindex="-1" role="dialog" aria-labelledby="myModalLabel" aria-hidden="true">
    <!-- Modal content -->
    <div class="modal-dialog">
        <div class="modal-content">
            <div class="modal-header">
                <h2>Confirm</h2>
            </div>
            <div class="modal-body">
                Do you really want to delete?
            </div>
            <div class="modal-footer">
                <button type="button" class="btn btn-default" data-dismiss="modal">Cancel</button>
                <a class="btn btn-danger btn-ok">Delete</a>
            </div>
        </div>
    </div>
</div>
<?php
if (isset($_GET['create'])){

// Create form
?>
    <div class="col-md-8 mx-auto">
        <div class="card-body">
            <div class="card bg-primary text-white">
                <div class="card-header card-header-warning">
                    <center>
                        <h2><i class="icon icon-bullhorn"></i> Announcements</h2>
                    </center>
                </div>
                
                <div class="card-body">
                    <div class="col-12">
                        <h3>Create Announcement</h3>
                    </div>
                    <form method="post">
                        <div class="form-group">
                            <label class="form-label" for="title">Title</label>
                            <input class="form-control" id="title" name="title" placeholder="Title" type="text" required/>
                        </div>
                        <div class="form-group">
                            <label class="form-label" for="short_description">Short Description</label>
                            <textarea class="form-control" id="short_description" name="short_description" placeholder="Short Description" required></textarea>
                        </div>
                        <div class="form-group">
                            <label class="form-label" for="image">Image URL</label>
                            <input class="form-control" id="image" name="image" placeholder="Image URL" type="text"/>
                        </div>
                        <div class="form-group">
                            <center>
                                <button class="btn btn-info" name="submit" type="submit">
                                    <i class="icon icon-check"></i> Submit
                                </button>
                            </center>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php
} else if (isset($_GET['update'])){

// Update form
?>
    <div class="col-md-8 mx-auto">
        <div class="card-body">
            <div class="card bg-primary text-white">
                <div class="card-header card-header-warning">
                    <center>
                        <h2><i class="icon icon-bullhorn"></i> Announcements</h2>
                    </center>
                </div>
                
                <div class="card-body">
                    <div class="col-12">
                        <h3>Edit Announcement</h3>
                    </div>
                    <form method="post">
                        <div class="form-group">
                            <label class="form-label" for="title">Title</label>
                            <input class="form-control" id="title" name="title" placeholder="Title" value="<?= htmlspecialchars($resU[0]['title']) ?>" type="text" required/>
                        </div>
                        <div class="form-group">
                            <label class="form-label" for="short_description">Short Description</label>
                            <textarea class="form-control" id="short_description" name="short_description" placeholder="Short Description" required><?= htmlspecialchars($resU[0]['short_description']) ?></textarea>
                        </div>
                        <div class="form-group">
                            <label class="form-label" for="image">Image URL</label>
                            <input class="form-control" id="image" name="image" placeholder="Image URL" value="<?= htmlspecialchars($resU[0]['image']) ?>" type="text"/>
                        </div>
                        <div class="form-group">
                            <center>
                                <button class="btn btn-info" name="submitU" type="submit">
                                    <i class="icon icon-check"></i> Submit
                                </button>
                            </center>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>
<?php
} else {
// Main table/form
?>
    <div class="col-md-12 mx-auto">
        <div class="card-body">
            <div class="card bg-primary text-white">
                <div class="card-header card-header-warning">
                    <center>
                        <h2><i class="icon icon-commenting"></i> Announcements</h2>
                    </center>
                </div>

                <div class="card-body">
                    <div class="col-12">
                        <center>
                            <a id="button" href="./<?=basename($_SERVER["SCRIPT_NAME"]) ?>?create" class="btn btn-info">New Announcement</a>
                        </center>
                    </div>
                    <br>
                    <div class="table-responsive">
                        <table class="table table-striped table-sm">
                            <thead style="color:white!important">
                                <tr>
                                    <th>ID</th>
                                    <th>Title</th>
                                    <th>Short Description</th>
                                    <th>Image</th>
                                    <th>Created At</th>
                                    <th>Edit&nbsp;&nbsp;&nbsp;Delete</th>
                                </tr>
                            </thead>
                            <?php foreach ($res as $row) { ?>
                            <tbody>
                                <tr>
                                    <td><?= $row['id'] ?></td>
                                    <td><?= htmlspecialchars($row['title']) ?></td>
                                    <td><?= htmlspecialchars($row['short_description']) ?></td>
                                    <td>
                                        <?php if (!empty($row['image'])) { ?>
                                            <img src="<?= htmlspecialchars($row['image']) ?>" alt="Image" style="max-height:50px;">
                                        <?php } ?>
                                    </td>
                                    <td><?= $row['created_at'] ?></td>
                                    <td>
                                        <a class="btn btn-info btn-ok" href="./<?= basename($_SERVER["SCRIPT_NAME"]) ?>?update=<?= $row['id'] ?>"><i class="fa fa-pencil-square-o"></i></a>
                                        &nbsp;&nbsp;&nbsp;
                                        <a class="btn btn-danger btn-ok" href="#" data-href="./<?= basename($_SERVER["SCRIPT_NAME"]) ?>?delete=<?= $row['id'] ?>" data-toggle="modal" data-target="#confirm-delete"><i class="fa fa-trash-o"></i></a>
                                    </td>
                                </tr>
                            </tbody>
                            <?php } ?>
                        </table>
                    </div>
                </div>
            </div>
        </div>
    </div>
<?php } ?>

<?php include ('includes/footer.php'); ?>

</body>
</html>
